IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_PROD_CPL_MEDIAF_MEDIAP]'))
DROP VIEW [dbo].[V_EST_PROD_CPL_MEDIAF_MEDIAP]
GO

CREATE VIEW [dbo].[V_EST_PROD_CPL_MEDIAF_MEDIAP]

AS
SELECT     
	dbo.EST_PROD_CPL_MEDIAF.CD_EMP, 
	dbo.EST_PROD_CPL_MEDIAF.CD_FILIAL, 
	dbo.EST_PROD_CPL_MEDIAF.CD_PROD, 
	dbo.EST_PROD_CPL_MEDIAF.QTDE_MEDIAF,
	dbo.EST_PROD_CPL_MEDIAF.CD_SIGLA, 
	CASE WHEN EST_PROD_CPL_MEDIAF.QTDE_MEDIAF > 0 THEN 
		0 
	ELSE 
		ISNULL(EST_PROD_CPL_MEDIAP.QTDE_MEDIAP, 0) 
	END AS QTDE_MEDIAP, 
	CASE WHEN ISNULL(EST_PROD_CPL_MEDIAF.QTDE_MEDIAF,0) > 0 THEN 
		ISNULL(EST_PROD_CPL_MEDIAF.QTDE_MEDIAF,0) 
	ELSE 
		CASE WHEN ISNULL(MEDIA_F_LIBERADA,0) = 0 THEN
			ISNULL(EST_PROD_CPL_MEDIAP.QTDE_MEDIAP, 0) 
		ELSE
			0
		END
	END AS QTDE_MEDIA, 
	CASE WHEN VLR_OFERTA > 0 THEN 
		VLR_OFERTA 
	ELSE 
		VLR_TABELA 
	END AS VLR_VENDA, 
    CASE WHEN EST_PROD_CPL_MEDIAF.QTDE_MEDIAF > 0  THEN 
		CASE WHEN VLR_OFERTA > 0 THEN 
			VLR_OFERTA * EST_PROD_CPL_MEDIAF.QTDE_MEDIAF
		ELSE 
			VLR_TABELA * EST_PROD_CPL_MEDIAF.QTDE_MEDIAF 
		END 
	ELSE 
		CASE WHEN ISNULL(MEDIA_F_LIBERADA,0) = 0 THEN
			CASE WHEN VLR_OFERTA > 0 THEN 
				VLR_OFERTA * ISNULL(EST_PROD_CPL_MEDIAP.QTDE_MEDIAP,0) 
			ELSE 
				VLR_TABELA * ISNULL(EST_PROD_CPL_MEDIAP.QTDE_MEDIAP, 0) 
			END 
		ELSE
			0
		END
	END AS VLR_VENDA_TOTAL, 
    dbo.EST_PROD_CPL_MEDIAF.QTDE_FINANCIADO, 
    dbo.EST_PROD_CPL_MEDIAF.QTDE_FACEAMENTO, 
    dbo.EST_PROD_CPL_MEDIAF.QTDE_LIMITADOR, 
    dbo.EST_PROD_CPL_MEDIAF.QT_VD_ATUAL, 
    dbo.EST_PROD_CPL_MEDIAF.QT_VD_MES1, 
    dbo.EST_PROD_CPL_MEDIAF.QT_VD_MES2, 
    dbo.EST_PROD_CPL_MEDIAF.QT_VD_MES3,
    EST_PROD.STS_PROD,
    EST_PROD_CPL.STS_PROD AS STS_PROD_FILIAL,
    EST_PROD_CPL_MEDIAF.PERC_ESEG_FACEAMENTO,
	ISNULL(EST_PROD_CPL_MEDIAF.FLAG_FACE_COMPLEMENTAR,0) AS FLAG_FACE_COMPLEMENTAR
FROM         
	EST_PROD_CPL_MEDIAF
	INNER JOIN EST_PROD ON
		EST_PROD_CPL_MEDIAF.CD_EMP = EST_PROD.CD_EMP
		AND EST_PROD_CPL_MEDIAF.CD_PROD = EST_PROD.CD_PROD
	LEFT OUTER JOIN dbo.EST_PROD_CPL_MEDIAP ON 
		dbo.EST_PROD_CPL_MEDIAF.CD_EMP = dbo.EST_PROD_CPL_MEDIAP.CD_EMP AND 
		dbo.EST_PROD_CPL_MEDIAF.CD_FILIAL = dbo.EST_PROD_CPL_MEDIAP.CD_FILIAL AND 
		dbo.EST_PROD_CPL_MEDIAF.CD_PROD = dbo.EST_PROD_CPL_MEDIAP.CD_PROD 
	LEFT OUTER JOIN dbo.EST_PROD_PRECO ON 
		dbo.EST_PROD_CPL_MEDIAF.CD_EMP = dbo.EST_PROD_PRECO.CD_EMP AND 
		dbo.EST_PROD_CPL_MEDIAF.CD_FILIAL = dbo.EST_PROD_PRECO.CD_FILIAL AND 
		dbo.EST_PROD_CPL_MEDIAF.CD_PROD = dbo.EST_PROD_PRECO.CD_PROD
	LEFT OUTER JOIN dbo.EST_PROD_CPL_NASC ON 
		dbo.EST_PROD_CPL_MEDIAF.CD_EMP = dbo.EST_PROD_CPL_NASC.CD_EMP AND 
		dbo.EST_PROD_CPL_MEDIAF.CD_FILIAL = dbo.EST_PROD_CPL_NASC.CD_FILIAL AND 
		dbo.EST_PROD_CPL_MEDIAF.CD_PROD = dbo.EST_PROD_CPL_NASC.CD_PROD
	INNER JOIN dbo.EST_PROD_CPL ON 
		dbo.EST_PROD_CPL_MEDIAF.CD_EMP = dbo.EST_PROD_CPL.CD_EMP AND 
		dbo.EST_PROD_CPL_MEDIAF.CD_FILIAL = dbo.EST_PROD_CPL.CD_FILIAL AND 
		dbo.EST_PROD_CPL_MEDIAF.CD_PROD = dbo.EST_PROD_CPL.CD_PROD


